( function( $ ) { "use strict";	
	'use strict';
	
	// OnePage Scrolling
	$('a[href*="#"]:not([href="#"]), .scroll[href*="#"]:not([href="#"])').on("click", function() {
		if (location.pathname.replace(/^\//, '') === this.pathname.replace(/^\//, '') && location.hostname === this.hostname) {
			var toHash = $(this.hash), toHashN = (this.hash.slice(1)) ? $('[name=' + this.hash.slice(1) + ']') : false, nbar = 0;

			toHash = toHash.length ? toHash : toHashN;
			if (toHash.length) {
				$('html, body').animate({
					scrollTop: (toHash.offset().top - nbar)
				}, 1000, "easeInOutExpo");
				return false;
			}
		}
	});

	/* ========================================== 
	Header Mobile
	========================================== */
	/* mobile_mainmenu create span */
	$('.collapse .mobile_mainmenu li:has(ul)').prepend('<span class="arrow"><i class="flaticon-arrow-point-to-right"></i></span>');

	$( "#mmenu_toggle" ).on('click', function() {
		$(this).toggleClass( "active" );
		if ($(this).hasClass( "active" )) {
			$('.mobile_nav').stop(true, true).slideDown();
		}else{
			$('.mobile_nav').stop(true, true).slideUp();
		}		
	});

	$(".mobile_mainmenu > li span.arrow").click(function() {
        $(this).parent().find("> ul").stop(true, true).slideToggle()
        $(this).toggleClass( "active" ); 
    });

    var swiper = new Swiper('.plugins-icon-slide', {
    	slidesPerView: 1,
		spaceBetween: 10,
      	breakpoints: {
      		480: {
	          slidesPerView: 2,
	          spaceBetween: 20,
	        },
	        640: {
	          slidesPerView: 3,
	          spaceBetween: 20,
	        },
	        768: {
	          slidesPerView: 4,
	          spaceBetween: 30,
	        },
	        1024: {
	          slidesPerView: 5,
	          spaceBetween: 40,
	        },
	        1200: {
	          slidesPerView: 6,
	          spaceBetween: 50,
	        },
	    },
    });

	var swiper = new Swiper('.compatible-slide', {
    	slidesPerView: 1,
		spaceBetween: 10,
      	breakpoints: {
      		480: {
	          slidesPerView: 2,
	          spaceBetween: 20,
	        },
	        640: {
	          slidesPerView: 3,
	          spaceBetween: 20,
	        },
	    },
    });

	var swiper = new Swiper('.inner-page-slide', {
    	slidesPerView: 5,
		spaceBetween: 30,
      	breakpoints: {
	        640: {
	          slidesPerView: 2,
	          spaceBetween: 30,
	        },
	        768: {
	          slidesPerView: 3,
	          spaceBetween: 30,
	        },
	        1024: {
	          slidesPerView: 4,
	          spaceBetween: 30,
	        },
	        1200: {
	          slidesPerView: 5,
	          spaceBetween: 30,
	        },
	    },
    });
} )(jQuery);